<?php
/**
 * FormDataItem
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  DocuSign\eSign
 * @author   Swagger Codegen team <apihelp@docusign.com>
 * @license  The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * DocuSign REST API
 *
 * The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.
 *
 * OpenAPI spec version: v2.1
 * Contact: devcenter@docusign.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 2.4.21
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace DocuSign\eSign\Model;

use \ArrayAccess;
use DocuSign\eSign\ObjectSerializer;

/**
 * FormDataItem Class Doc Comment
 *
 * @category    Class
 * @package     DocuSign\eSign
 * @author      Swagger Codegen team <apihelp@docusign.com>
 * @license     The DocuSign PHP Client SDK is licensed under the MIT License.
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FormDataItem implements ModelInterface, ArrayAccess
{
    const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $swaggerModelName = 'formDataItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerTypes = [
        'error_details' => '\DocuSign\eSign\Model\ErrorDetails',
        'list_selected_value' => '?string',
        'name' => '?string',
        'numerical_value' => '?string',
        'original_numerical_value' => '?string',
        'original_value' => '?string',
        'value' => '?string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $swaggerFormats = [
        'error_details' => null,
        'list_selected_value' => null,
        'name' => null,
        'numerical_value' => null,
        'original_numerical_value' => null,
        'original_value' => null,
        'value' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function swaggerFormats()
    {
        return self::$swaggerFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'error_details' => 'errorDetails',
        'list_selected_value' => 'listSelectedValue',
        'name' => 'name',
        'numerical_value' => 'numericalValue',
        'original_numerical_value' => 'originalNumericalValue',
        'original_value' => 'originalValue',
        'value' => 'value'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'error_details' => 'setErrorDetails',
        'list_selected_value' => 'setListSelectedValue',
        'name' => 'setName',
        'numerical_value' => 'setNumericalValue',
        'original_numerical_value' => 'setOriginalNumericalValue',
        'original_value' => 'setOriginalValue',
        'value' => 'setValue'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'error_details' => 'getErrorDetails',
        'list_selected_value' => 'getListSelectedValue',
        'name' => 'getName',
        'numerical_value' => 'getNumericalValue',
        'original_numerical_value' => 'getOriginalNumericalValue',
        'original_value' => 'getOriginalValue',
        'value' => 'getValue'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$swaggerModelName;
    }

    

    

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['error_details'] = isset($data['error_details']) ? $data['error_details'] : null;
        $this->container['list_selected_value'] = isset($data['list_selected_value']) ? $data['list_selected_value'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['numerical_value'] = isset($data['numerical_value']) ? $data['numerical_value'] : null;
        $this->container['original_numerical_value'] = isset($data['original_numerical_value']) ? $data['original_numerical_value'] : null;
        $this->container['original_value'] = isset($data['original_value']) ? $data['original_value'] : null;
        $this->container['value'] = isset($data['value']) ? $data['value'] : null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets error_details
     *
     * @return \DocuSign\eSign\Model\ErrorDetails
     */
    public function getErrorDetails()
    {
        return $this->container['error_details'];
    }

    /**
     * Sets error_details
     *
     * @param \DocuSign\eSign\Model\ErrorDetails $error_details Array or errors.
     *
     * @return $this
     */
    public function setErrorDetails($error_details)
    {
        $this->container['error_details'] = $error_details;

        return $this;
    }

    /**
     * Gets list_selected_value
     *
     * @return ?string
     */
    public function getListSelectedValue()
    {
        return $this->container['list_selected_value'];
    }

    /**
     * Sets list_selected_value
     *
     * @param ?string $list_selected_value 
     *
     * @return $this
     */
    public function setListSelectedValue($list_selected_value)
    {
        $this->container['list_selected_value'] = $list_selected_value;

        return $this;
    }

    /**
     * Gets name
     *
     * @return ?string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param ?string $name 
     *
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets numerical_value
     *
     * @return ?string
     */
    public function getNumericalValue()
    {
        return $this->container['numerical_value'];
    }

    /**
     * Sets numerical_value
     *
     * @param ?string $numerical_value 
     *
     * @return $this
     */
    public function setNumericalValue($numerical_value)
    {
        $this->container['numerical_value'] = $numerical_value;

        return $this;
    }

    /**
     * Gets original_numerical_value
     *
     * @return ?string
     */
    public function getOriginalNumericalValue()
    {
        return $this->container['original_numerical_value'];
    }

    /**
     * Sets original_numerical_value
     *
     * @param ?string $original_numerical_value 
     *
     * @return $this
     */
    public function setOriginalNumericalValue($original_numerical_value)
    {
        $this->container['original_numerical_value'] = $original_numerical_value;

        return $this;
    }

    /**
     * Gets original_value
     *
     * @return ?string
     */
    public function getOriginalValue()
    {
        return $this->container['original_value'];
    }

    /**
     * Sets original_value
     *
     * @param ?string $original_value The initial value of the tab when it was sent to the recipient.
     *
     * @return $this
     */
    public function setOriginalValue($original_value)
    {
        $this->container['original_value'] = $original_value;

        return $this;
    }

    /**
     * Gets value
     *
     * @return ?string
     */
    public function getValue()
    {
        return $this->container['value'];
    }

    /**
     * Sets value
     *
     * @param ?string $value Specifies the value of the tab.
     *
     * @return $this
     */
    public function setValue($value)
    {
        $this->container['value'] = $value;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    #[\ReturnTypeWillChange]
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     *
     * @param integer $offset Offset
     * @param mixed   $value  Value to be set
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    #[\ReturnTypeWillChange]
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(
                ObjectSerializer::sanitizeForSerialization($this),
                JSON_PRETTY_PRINT
            );
        }

        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}

